#include <bits/stdc++.h>

#define int int64_t
using namespace std;

bool is_palindrome(int x) {
    // 0 <= x <= 999
    if (x / 100 > 0) {
        return x / 100 == x % 10;
    } else if (x / 10 > 0) {
        return x / 10 == x % 10;
    } else {
        return true;
    }
}

const int INF = 2e9;

void solve() {
    vector<int> dp(1000, INF);
    dp[0] = 0;
    dp[1] = 1;
    vector<int> palindromes;
    for (int i = 1; i <= 999; i++) {
        if (is_palindrome(i)) {
            palindromes.push_back(i);
        }
    }
    for (int i = 2; i <= 999; i++) {
        for (auto &palindrome : palindromes) {
            if (palindrome > i) {
                break;
            }
            dp[i] = min(dp[i], dp[i - palindrome] + 1);
        }
    }
    int q;
    cin >> q;
    while (q--) {
        int x;
        cin >> x;
        cout << dp[x] << '\n';
    }
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int tt = 1;
//    cin >> tt;
    while (tt--) {
        solve();
    }
    return 0;
}
